package ftp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;

public class CommandeSTOR extends Commande {
	
	public CommandeSTOR(PrintStream ps, String commandeStr) {
		super(ps, commandeStr);
	}

	public void execute() {

		
		if (commandeArgs.length == 0)
		{
			ps.println("2 La commande doit contenir l'adresse du fichier à envoyer.");
			// return;
		}
		else
		{
			
			try {
				
				String pathFileToReceive = commandeArgs[0];
				File fileToReceive = new File(pathFileToReceive);
				
				
				if (!fileToReceive.exists())
				{
					System.out.println("Le fichier rentré n'existe pas.");
										
					return;
				}
				
				String fileNameToReceive = fileToReceive.getName();
				
				ServerSocket serveurSocketFile;
				serveurSocketFile = new ServerSocket(12345);
				
				System.out.println("1 Serveur prêt.");
				ps.println("1 Serveur prêt.");
				Socket socketFile = serveurSocketFile.accept(); // On attend qu'un client se connecte
				System.out.println("Connexion acceptée : " + socketFile);
				
				// On crée un flux d'entrée pour recevoir le fichier
				InputStream in = socketFile.getInputStream();
				
				// On crée un flux de sortie pour écrire le fichier sur le disque
				FileOutputStream out = new FileOutputStream(CommandExecutor.currentFile.getAbsolutePath() + "\\" + fileNameToReceive);
				
				// On crée un tampon pour lire les données du flux d'entrée
				byte[] buffer = new byte[1024];
				
				// On lit les données du flux d'entrée et on les écrit dans le fichier de sortie
				int bytesRead;
				while ((bytesRead = in.read(buffer)) != -1) {
					out.write(buffer, 0, bytesRead);
				}
				
				// On ferme les flux et la connexion avec le client
				out.close();
				in.close();
				socketFile.close();
				
				ps.println("0 Fichier reçu !");
				
				serveurSocketFile.close();
				
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} // On écoute sur le port 12345
			
		}
		
        

		
		
		
	}

}
